// my scripts
// Replace Instagram images with Scooby images

const SCOOBY_IMAGES = [
  chrome.runtime.getURL("images/scoobydoo1.png"),
  chrome.runtime.getURL("images/scoobydoo2.png"),
  chrome.runtime.getURL("images/scoobydoo3.png"),
  chrome.runtime.getURL("images/scoobydoo4.png"),
  chrome.runtime.getURL("images/scoobydoo5.png"),
  chrome.runtime.getURL("images/scoobydoo6.png"),
  chrome.runtime.getURL("images/scoobydoo7.png"),
  chrome.runtime.getURL("images/scoobydoo8.png"),
  chrome.runtime.getURL("images/scoobydoo9.png"),
  chrome.runtime.getURL("images/scoobydoo10.png"),
  chrome.runtime.getURL("images/scoobydoo11.png")

];

// Pick a Scooby image (random)
function pickScooby() {
  return SCOOBY_IMAGES[Math.floor(Math.random() * SCOOBY_IMAGES.length)];
}

// Replace a single <img>
function replaceImg(img) {
  if (!img || img.dataset.scoobyReplaced === "true") return;

  // Instagram uses many different image URLs; we just swap the src
  // Keep sizing stable by remembering original src (optional)
  img.dataset.originalSrc = img.currentSrc || img.src;

  const scoobySrc = pickScooby();
  img.src = scoobySrc;
  img.srcset = scoobySrc; // helps when IG uses srcset
  img.dataset.scoobyReplaced = "true";
}

// Replace all images currently in DOM
function replaceAllImages() {
  // Many IG images are plain <img> tags
  const imgs = document.querySelectorAll("img");
  imgs.forEach(replaceImg);
}

// Run once on load
replaceAllImages();

// Keep replacing as Instagram dynamically loads content
const observer = new MutationObserver((mutations) => {
  for (const m of mutations) {
    // Check added nodes for images
    m.addedNodes.forEach((node) => {
      if (node.nodeType !== 1) return;

      if (node.tagName === "IMG") {
        replaceImg(node);
      } else {
        const imgs = node.querySelectorAll?.("img");
        imgs?.forEach(replaceImg);
      }
    });
  }
});

// Observe the whole page
observer.observe(document.documentElement, {
  childList: true,
  subtree: true
});

// Optional: also re-run occasionally (IG can rewrite attributes)
setInterval(replaceAllImages, 3000);
